/*
Copyright (c) 2006 Lim Chong Liang Andrew

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef WINDOW_H
#define WINDOW_H
#include <windows.h>

/**
   Wrapper for CreateWindow and DestroyWindow functions.
   
   @author Copyright  2006 Andrew Lim   
 */
class Window {
public:
  
  /**
     Constructs a Window object.
   */
  Window();
  
  /**
     Destroys the Window object.
   */
  ~Window();  
  
  /**
      Centers the window in the screen.
   */
  void centerInScreen() ;
  
  /**
      Creates the on screen window.
   */
  bool create( LPCTSTR text, HWND hwndParent, DWORD style, DWORD exstyle ) ;

  /**
      Destroys the on screen window.
   */
  void destroy() ;
  
  /**
      Returns the handle to the window if it was created; NULL otherwise.
   */
  HWND getHandle() const
  {
    return hwnd ;
  }

  /**
      Sets the client size of the window.
   */
  void setClientSize( int clientWidth, int clientHeight );               
               
  /**
      Sets the message handler object that will handle the window's messages.
   */
  template <class T, LRESULT (T::*F) ( HWND , UINT , WPARAM , LPARAM  )>
  void setMessageHandler( T& t )
  {
    pMessageHandler = reinterpret_cast<void*>( &t ) ;
    stub = &Unused::functionStub<T,F> ;
  }
  
  /**
      Calls ShowWindow.
   */
  void show( int nCmdShow = SW_SHOWNORMAL )
  {
    ShowWindow( hwnd, nCmdShow );
  }
  
private:
  
  /**
      This object is not Assignable.
   */
  Window( const Window& );
  
  /**
      This object is not Assignable.
   */  
  Window& operator= ( const Window& );    

  /**
      Bug fix for VC++ 6.0 ?
   */  
  struct Unused
  {
    /**
        stub points to an instance of this function
     */    
    template <class T, LRESULT (T::*F) ( HWND , UINT , WPARAM , LPARAM  )>
    static LRESULT functionStub( void* v, HWND h, UINT m, WPARAM w, LPARAM l )
    {
      T* t = reinterpret_cast<T*>( v );
      return (t->*F)( h, m, w, l );
    }
  };

  /**
     The WNDPROC.
   */
  static LRESULT CALLBACK wndproc( HWND h, UINT m, WPARAM w, LPARAM l );
  
private:
  
  /** window handle */
  HWND hwnd ;    
  
  /** pointer to message handler object */
  void* pMessageHandler ;
  
  /* points to an instance of functionStub */
  LRESULT (*stub)( void*, HWND , UINT , WPARAM , LPARAM );
  

};
#endif
