/*
Copyright (c) 2006 Lim Chong Liang Andrew

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include "Window.h"
#include "resource.h"

//------------------------------------------------------------------------------
//  Constructors & Destructors
//------------------------------------------------------------------------------

Window::Window()
  : hwnd( NULL )
  , pMessageHandler( 0 )
  , stub(0 )
{}

Window::~Window()
{
  destroy() ;
}

//------------------------------------------------------------------------------
//  Member Functions
//------------------------------------------------------------------------------

void Window::centerInScreen()
{
  if ( hwnd )
  {
    RECT rc ;

    GetWindowRect ( hwnd, &rc ) ;

    SetWindowPos( hwnd, 0,
                  (GetSystemMetrics(SM_CXSCREEN) - rc.right)/2,
                  (GetSystemMetrics(SM_CYSCREEN) - rc.bottom)/2,
                  0, 0, SWP_NOZORDER|SWP_NOSIZE );
  }
}

bool Window::create( LPCTSTR text,
                     HWND hwndParent,
                     DWORD dwStyle,
                     DWORD dwExStyle )
{
  destroy();

  WNDCLASS wc = {0};
  wc.lpszClassName = TEXT( "DanteDarkness" );
  wc.hInstance     = GetModuleHandle(0) ;
  wc.hbrBackground = GetSysColorBrush( COLOR_3DFACE );
  wc.lpfnWndProc   = wndproc ;
  wc.hCursor       = LoadCursor(0,IDC_ARROW);
  wc.hIcon         = LoadIcon(GetModuleHandle(NULL),MAKEINTRESOURCE(ID_MAINICON));
  RegisterClass(&wc);

  return CreateWindowEx(dwExStyle,wc.lpszClassName,text,dwStyle,
                        0,0,0,0,hwndParent,0,GetModuleHandle(0),this) != NULL;
}

void Window::destroy()
{
  DestroyWindow( hwnd ) ;
  hwnd = NULL ;
}

void Window::setClientSize( int clientWidth, int clientHeight )
{
  if ( IsWindow( hwnd ) )
  {
    DWORD dwStyle = GetWindowLongPtr( hwnd, GWL_STYLE ) ;
    DWORD dwExStyle = GetWindowLongPtr( hwnd, GWL_EXSTYLE ) ;
    HMENU menu = GetMenu( hwnd ) ;

    RECT rc = { 0, 0, clientWidth, clientHeight } ;

    AdjustWindowRectEx( &rc, dwStyle, menu ? TRUE : FALSE, dwExStyle );

    SetWindowPos( hwnd, NULL, 0, 0, rc.right - rc.left, rc.bottom - rc.top,
                  SWP_NOZORDER | SWP_NOMOVE ) ;
  }
}

//------------------------------------------------------------------------------
//  Static Functions & Data
//------------------------------------------------------------------------------

LRESULT CALLBACK
Window::wndproc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
  Window* self = (Window*)(LONG_PTR)GetWindowLongPtr(hwnd, GWLP_USERDATA) ;

  if ( self && self->stub && self->pMessageHandler )
    return self->stub( self->pMessageHandler, hwnd, msg, wParam, lParam);

  if (msg == WM_NCCREATE)
  {
    self = (Window*)(((LPCREATESTRUCT)lParam)->lpCreateParams);
    self->hwnd = hwnd ;
    SetWindowLongPtr(hwnd, GWLP_USERDATA, (LONG)(LONG_PTR)(self));
  }

  return DefWindowProc(hwnd, msg, wParam, lParam);
}
