#include "Splitter.h"

Splitter::Splitter( HWND parent, HWND leftChild, HWND rightChild )
  : x( 0 )
  , y( 0 )
  , w( 4 )
  , h( 0 )
  , parent( parent )
  , leftChild( leftChild )
  , rightChild( rightChild ) {
}

void Splitter::onParentLButtonDown( WPARAM wParam, LPARAM lParam ) {
  POINT cursor = { LOWORD( lParam ), HIWORD( lParam ) };
  RECT divider = { x, y, x+w, h };
  if ( PtInRect( &divider, cursor ) ) {
    SetCursor( LoadCursor(0,IDC_SIZEWE) );
    SetCapture( parent );
  }
}

void Splitter::onParentLButtonUp( WPARAM wParam, LPARAM lParam ) {
  POINT cursor = { LOWORD( lParam ), HIWORD( lParam ) };
  RECT divider = { x, y, x+w, h };
  if ( PtInRect( &divider, cursor ) ) {
    SetCursor( LoadCursor(0,IDC_SIZEWE) );
  }
  if ( GetCapture() == parent ) {
    ReleaseCapture() ;
  }
}

void Splitter::onParentMouseMove( WPARAM wParam, LPARAM lParam ) {
  int clientX = LOWORD( lParam );
  int clientY = HIWORD( lParam );
  POINT cursor = { clientX, clientY };
  RECT divider = { x, y, x+w, h };
  if ( PtInRect( &divider, cursor ) ) {
    SetCursor( LoadCursor(0,IDC_SIZEWE) );
  }
  if ( GetCapture() == parent ) {
    RECT rcClient ; GetClientRect( parent, &rcClient );
    if ( clientX > 0 && (clientX+w) <= rcClient.right ) {
      x = clientX ;
      updateChildren();
    }
  }
}

void Splitter::onParentSize( WPARAM wParam, LPARAM lParam ) {
  h = HIWORD( lParam ); // client height
  updateChildren();
}


void Splitter::updateChildren() {
  RECT client ;
  GetClientRect( parent, &client );
  RECT divider = { x, y, x+w, h };
  if ( leftChild ) {
    SetWindowPos( leftChild, 0, 0, 0, divider.left, 
                  client.bottom, SWP_NOZORDER );
  }
  if ( rightChild ) {
    SetWindowPos( rightChild, 0, divider.right, 0,
                  client.right - divider.right, 
                  client.bottom, SWP_NOZORDER );
  }
}
