#include "Slashes.h"

String& Slashes::add( String& s ) {
  String s2 ;
  s2.reserve( s.size() );
  for ( size_t i = 0; i < s.size(); ++i ) {
    const char c = s[ i ] ;
    switch ( c ) {
      case '\\': s2 += "\\\\" ; continue ;
      case '{':  s2 += "\\o" ;  continue ;
      case '}':  s2 += "\\c" ;  continue ;
      default:   s2 += c ;      continue ;
    }
  }
  s = s2 ;
  return s ;
}

String& Slashes::strip( String& s ) {
  String s2 ;
  s2.reserve( s.size() );
  for ( size_t i = 0; i < s.size(); ++i ) {
    const char curr = s[ i ] ;
    if ( curr == '\\' && i+1 != s.size() ) {
      const char next = s[ i + 1 ] ;
      switch ( next ) {
        case '\\': s2 += "\\" ; ++i ; continue ;
        case 'o' : s2 += "{"  ; ++i ; continue ;
        case 'c' : s2 += "}"  ; ++i ; continue ;
      }
    }
    else {
      s2 += curr ;
    }
  }
  s = s2 ;
  return s ;
}
