#ifndef SETTINGS_H
#define SETTINGS_H

#include <windows.h>
#include "CString.h"
#include "Record.h"
#include "Font.h"

class Settings {
public:
  static const int DEFAULT_COLOR = RGB(0,0,0);
  static const int DEFAULT_BACKGROUND_COLOR = RGB(255,255,255) ;
  static const int DEFAULT_FONT_HEIGHT = 10 ;
  static const int DEFAULT_WINDOW_X = 0 ;
  static const int DEFAULT_WINDOW_Y = 0 ;
  static const int DEFAULT_WINDOW_WIDTH = 400 ;
  static const int DEFAULT_WINDOW_HEIGHT = 300 ;
  static const bool DEFAULT_WINDOW_MAXIMIZED ;
  static const TCHAR DEFAULT_FONT_NAME[] ;
  static const bool DEFAULT_FONT_BOLD ;
  static const bool DEFAULT_FONT_ITALIC ;
  static const int DEFAULT_SPLITTER_X = 200 ;
public:
  Settings();
  COLORREF getBackgroundColor() const ;
  COLORREF getColor() const ;
  int getSplitterX() const ;
  int getWindowHeight() const ;
  int getWindowWidth() const ;
  int getWindowX() const ;
  int getWindowY() const ;
  const Font& getFont() const ;
  bool isWindowMaximized() const ;
  bool load( const String& fileName );
  bool save( const String& fileName );
  void setBackgroundColor( const String& );
  void setBackgroundColor( COLORREF );
  void setColor( const String& );
  void setColor( COLORREF );
  void setFont( const Font& );
  void setSplitterX( int );
  void setWindowHeight( int i ) ;
  void setWindowMaximized( bool );
  void setWindowWidth( int i ) ;
  void setWindowX( int i ) ;
  void setWindowY( int i ) ;
private:
  bool intToString( int i, String& s );
  bool stringToInt( const String& s, int& i );
private:
  Font font ;
  COLORREF color, backgroundColor ;
  int windowX, windowY, windowWidth, windowHeight ;
  bool windowMaximized ;
  int splitterX ;
};

#endif
