#include "Settings.h"
#include "Database.h"
#include <tchar.h>

using namespace std ;

//------------------------------------------------------------------------------
// Static Data
//------------------------------------------------------------------------------

const TCHAR Settings::DEFAULT_FONT_NAME[]      = TEXT("Courier New");
const bool  Settings::DEFAULT_FONT_BOLD        = false ;
const bool  Settings::DEFAULT_FONT_ITALIC      = false ;
const bool  Settings::DEFAULT_WINDOW_MAXIMIZED = false ;

//------------------------------------------------------------------------------
// Constructors and Destructors
//------------------------------------------------------------------------------

Settings::Settings()
  : font( DEFAULT_FONT_NAME, DEFAULT_FONT_HEIGHT, DEFAULT_FONT_BOLD,
          DEFAULT_FONT_ITALIC)
  , color( DEFAULT_COLOR )
  , backgroundColor( DEFAULT_BACKGROUND_COLOR )
  , windowX(DEFAULT_WINDOW_X)
  , windowY(DEFAULT_WINDOW_Y)
  , windowWidth(DEFAULT_WINDOW_WIDTH)
  , windowHeight(DEFAULT_WINDOW_HEIGHT)
  , windowMaximized(DEFAULT_WINDOW_MAXIMIZED)
  , splitterX(DEFAULT_SPLITTER_X) {
}

//------------------------------------------------------------------------------
// Member Functions
//------------------------------------------------------------------------------

COLORREF Settings::getColor() const {
  return color ;
}

COLORREF Settings::getBackgroundColor() const {
  return backgroundColor ;
}

const Font& Settings::getFont() const {
  return font ;
}

int Settings::getSplitterX() const {
  return splitterX ;
}

bool Settings::isWindowMaximized() const {
  return windowMaximized ;
}

int Settings::getWindowHeight() const {
  return windowHeight ;
}

int Settings::getWindowWidth() const {
  return windowWidth ;
}

int Settings::getWindowX() const {
  return windowX ;
}

int Settings::getWindowY() const {
  return windowY ;
}

bool Settings::load( const String& fileName ) {
  Database database ;
  if ( !database.load( fileName ) ) {
    return false ;
  }

  String fontName   = DEFAULT_FONT_NAME ;
  bool   fontBold   = DEFAULT_FONT_BOLD ;
  bool   fontItalic = DEFAULT_FONT_ITALIC ;
  int    fontHeight = DEFAULT_FONT_HEIGHT ;

  for ( size_t i = 0; i < database.getSize(); ++i ) {
    const Record& record = database.get( i );
    const String& name = record.getName() ;
    const String& text = record.getText() ;
    if ( name == "color" ) {
      setColor( text );
    }
    else if ( name == "backgroundColor" ) {
      setBackgroundColor( text );
    }
    else if ( name == "fontName" ) {
      fontName = text ;
    }
    else if ( name == "fontHeight" ) {
      stringToInt( text, fontHeight );
    }
    else if ( name == "fontBold" ) {
      fontBold = text == "true" ;
    }
    else if ( name == "fontItalic" ) {
      fontItalic = text == "true" ;
    }
    else if ( name == "windowX" ) {
      stringToInt( text, windowX );
    }
    else if ( name == "windowY" ) {
      stringToInt( text, windowY );
    }
    else if ( name == "windowWidth" ) {
      stringToInt( text, windowWidth );
    }
    else if ( name == "windowHeight" ) {
      stringToInt( text, windowHeight );
    }
    else if ( name == "windowMaximized" ) {
      windowMaximized = text == "true" ;
    }
    else if ( name == "splitterX" ) {
      stringToInt( text, splitterX );
    }
  }
  font.create( fontName.c_str(), fontHeight, fontBold, fontItalic );
  return true ;
}

bool Settings::save( const String& fileName ) {
  Database database ;
  String text ;
  Record record ;

  // color
  intToString( (int) color, text );
  database.add( Record("color",text) );

  // backgroundColor
  intToString( (int) backgroundColor, text );
  database.add( Record("backgroundColor",text) );

  // fontName
  LOGFONT lf ;
  GetObject( font.getHandle(), sizeof(lf), &lf );
  database.add( Record("fontName",lf.lfFaceName) );

  // fontHeight
  intToString( font.getHeight(), text );
  database.add( Record("fontHeight", text) );

  // fontBold
  database.add( Record("fontBold", font.isBold() ? "true":"false") );

  // fontItalic
  database.add( Record("fontItalic", font.isItalic() ? "true":"false") );
  
  // window X Y
  intToString( (int) windowX, text );
  database.add( Record("windowX",text) );
  intToString( (int) windowY, text );
  database.add( Record("windowY",text) );
  
  // window Width Height
  intToString( (int) windowWidth, text );
  database.add( Record("windowWidth",text) );
  intToString( (int) windowHeight, text );
  database.add( Record("windowHeight",text) );
  
  // windowMaximized
  database.add( Record("windowMaximized", windowMaximized ? "true":"false") );
  
  // splitterX
  intToString( (int) splitterX, text );
  database.add( Record("splitterX",text) );

  return database.save(fileName) ;
}

void Settings::setColor( const String& s ) {
  int c = color ;
  stringToInt( s, c );
  color = c ;
}

void Settings::setColor( COLORREF c ) {
  color = c ;
}

void Settings::setBackgroundColor( const String& s ) {
  int c = backgroundColor ;
  stringToInt( s, c );
  backgroundColor = c ;
}

void Settings::setBackgroundColor( COLORREF c ) {
  backgroundColor = c ;
}

void Settings::setFont( const Font& f ) {
  font = f ;
}

void Settings::setSplitterX( int x ) {
  splitterX = x ;
}

void Settings::setWindowHeight( int height ) {
  windowHeight = height ;
}

void Settings::setWindowMaximized( bool b ) {
  windowMaximized = b ;
}

void Settings::setWindowWidth( int width ) {
  windowWidth = width ;
}

void Settings::setWindowX( int x ) {
  windowX = x ;
}

void Settings::setWindowY( int y ) {
  windowY = y ;
}

bool Settings::intToString( int i, String& s ) {
  TCHAR buf[ 64 ] ;
  buf[ 0 ] = '0' ;
  _stprintf( buf, _T("%d"), i );
  s = buf ;
  return true ;
}

bool Settings::stringToInt( const String& s, int& i ) {
  TCHAR* end ;
  i = _tcstol( s.c_str(), &end, 0 );
  return *end == '\0' ;
}

