#ifndef RECORD_DIALOG_H
#define RECORD_DIALOG_H
#include <windows.h>
#include "CString.h"
#include "Font.h"
#include "Brush.h"

class RecordDialog {
public:
  struct CreationException {};
public:
  RecordDialog( HWND hwndParent = NULL ) throw (CreationException) ;
  ~RecordDialog();
public:
  String& getName( String& ) const ;
  HWND getNameBox() const ;
  String& getText( String& ) const ;
  HWND getTextBox() const ;
  COLORREF getTextBackgroundColor() const ;
  COLORREF getTextColor() const ;
  bool isDialogMessage( LPMSG ) const ;
  bool isVisible() const ;
  void setName( const String& );
  void setText( const String& );
  void setTextBackgroundColor( COLORREF );
  void setTextColor( COLORREF );
  void setFont( const Font& f ) ;
  void setVisible( bool b );
  operator HWND() const { return hwnd; }
private:
  bool create( HWND ) ;
  void destroy();
  static INT_PTR CALLBACK DialogProc( HWND, UINT, WPARAM, LPARAM );
  static String& getWindowText( HWND, String& ) ;
  void onCancel() ;
  INT_PTR onCommand( WPARAM wParam, LPARAM lParam );
  INT_PTR onCtlColorEdit( WPARAM wParam, LPARAM lParam );
  INT_PTR onMessage( HWND, UINT, WPARAM, LPARAM lParam );
  INT_PTR onSize( WPARAM wParam, LPARAM lParam );
private:
  String   name, text ;
  Font     font ;
  HWND     hwnd, nameBox, textBox ;
  int      leftDiff, topDiff, rightDiff, bottomDiff ;
  COLORREF color ;
  Brush    backgroundBrush ;
  static const TCHAR PROPERTY_NAME[] ;
  static const TCHAR ERROR_NO_NAME[] ;
  static const TCHAR ERROR_NO_TEXT[] ;
};

#endif
