#include <cstdio>
#include "Record.h"
#include "Slashes.h"
using namespace std;

Record::Record( const String& newName, const String& newText )
  : name( newName )
  , text( newText ) {
}

void Record::read( FILE* f ) {
  if ( f ) {
    name.clear() ;
    text.clear() ;
    int c = 0 ;
    while ( c != EOF && (c=fgetc(f)) != '{' ) ;
    while ( c != EOF && (c=fgetc(f)) != '=' ) {
      name += c ;
    }
    while ( c != EOF && (c=fgetc(f)) != '}' ) {
      text += c ;
    }
    Slashes::strip( name ) ;
    Slashes::strip( text ) ;
  }
}

void Record::write( FILE* f ) const {
  String nameCopy( name ) ;
  String textCopy( text ) ;
  // Add slashes to \, { and }
  Slashes::add( nameCopy );
  Slashes::add( textCopy );
  // Write {name=value}
  fputc( '{', f );
  fwrite( nameCopy.c_str(), nameCopy.size(), 1, f );
  fputc( '=', f );
  fwrite( textCopy.c_str(), textCopy.size(), 1, f );
  fputc( '}', f );
}

const String& Record::getName() const {
  return name ;
}

const String& Record::getText() const {
  return text ;
}

void Record::setName( const String& newName ) {
  name = newName ;
}

void Record::setText( const String& newText ) {
  text = newText ;
}

/*
The following block of code that has been commented out is the C++ fstream
version of reading and writing a record. I decided not to use it anymore
because removing it helped to reduce executable size almost by half.

istream& operator >>(istream &is, Record &obj) {
  obj.name.clear() ;
  obj.text.clear() ;
  char c ;
  while ( is.get(c) && c != '{' ) ;
  getline( is, obj.name, '=' );
  getline( is, obj.text, '}' );
  Slashes::strip( obj.name ) ;
  Slashes::strip( obj.text ) ;
  return is;
}
ostream& operator <<(ostream& out,const Record& obj) {
  String name( obj.name ) ;
  String text( obj.text ) ;
  // Add slashes to characters escaped with a backslash.
  Slashes::add( name );
  Slashes::add( text );
  // Write the data.
  out << '{' << name << "=" << text << '}' ;
  return out ;
}
*/

