#ifndef LISTBOX_H
#define LISTBOX_H
#include <windows.h>
#include <commctrl.h>

class ListBox {
public:
  static const int DEFAULT_STYLE = WS_CHILD|WS_VISIBLE|LBS_NOINTEGRALHEIGHT|
                                   WS_HSCROLL|WS_VSCROLL|LBS_NOTIFY|WS_TABSTOP
                                   ;
public:
  ListBox()
    : hwnd(NULL) {
  }
  bool create( HWND parent,
               DWORD style=DEFAULT_STYLE,
               DWORD exstyle=WS_EX_CLIENTEDGE ) {
    destroy() ;
    hwnd = CreateWindowEx( exstyle,
                           TEXT("LISTBOX"),
                           TEXT(""),
                           style,
                           0,0,0,0,
                           parent,
                           0,
                           GetModuleHandle(NULL),
                           0);
    return hwnd != NULL ;
  }
  bool makeDragList() {
    return MakeDragList(hwnd) != 0 ;
  }
  void destroy() {
    if ( hwnd ) {
      DestroyWindow( hwnd ) ;
      hwnd = NULL ;
    }
  }
  UINT getSelectedIndex() const {
    return (UINT)SendMessage( hwnd, LB_GETCURSEL, 0, 0 );
  }
  UINT getCaretIndex() const {
    return (UINT)SendMessage( hwnd, LB_GETCARETINDEX, 0, 0 );
  }
  void getItemRect( UINT index, RECT* rc ) {
    SendMessage( hwnd, LB_GETITEMRECT, index, (LPARAM)rc );
  }
  void add( LPCTSTR text ) {
    SendMessage( hwnd, LB_ADDSTRING, 0, (LPARAM)text );
  }
  void insert( LPCTSTR s, UINT index ) {
    SendMessage( hwnd, LB_INSERTSTRING, index, (LPARAM) s ) ;
  }
  void remove( UINT index ) {
    SendMessage( hwnd, LB_DELETESTRING, index, 0 ) ;
  }
  void removeAll() {
    SendMessage( hwnd, LB_RESETCONTENT, 0, 0 );
  }
  // does a remove, then an insert
  void replace( UINT index, LPCTSTR s ) {
    //SendMessage( hwnd, LB_SETITEMDATA, index, (LPARAM)s );
    remove( index );
    insert( s, index );
  }
  void setHorizontalExtent( int i ) {
    SendMessage( hwnd, LB_SETHORIZONTALEXTENT, i, 0 );
  }
  void setSelectedIndex( UINT index ) {
    SendMessage( hwnd, LB_SETCURSEL, index, 0 );
  }
  void setSize( int width, int height ) {
    SetWindowPos( hwnd, NULL, 0, 0, width, height, SWP_NOMOVE|SWP_NOZORDER );
  }
  void setLocation( int x, int y ) {
    SetWindowPos( hwnd, NULL, x, y, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
  }
  operator HWND() {
    return hwnd ;
  }
  bool isVisible() const {
    return IsWindowVisible( hwnd ) == TRUE ;
  }

private:
  ListBox( const ListBox& );
  ListBox& operator=( const ListBox& );
private:
  HWND hwnd ;
};

#endif
