#ifndef DATABASE_H
#define DATABASE_H
#include <vector>
#include "Record.h"

class Database {
public:
  void add( const Record& record );
  Record& get( size_t i ) ;
  const Record& get( size_t i ) const ;
  size_t getSize() ;
  void insert( const Record& record, size_t i ) ;
  bool load( const String& fileName );
  void remove( size_t i );
  void removeAll() ;
  bool save( const String& fileName ) const ;
  void sortAscending() ;
  void sortDescending() ;
private:
  typedef std::vector< std::pair<size_t,size_t> > BracePairList ;
  std::vector<Record> records ;
  static bool sortAscendingComp( const Record& a, const Record& b ) ;
  static bool sortDescendingComp( const Record& a, const Record& b ) ;
};

#endif
