#include <algorithm>
#include <cstdio>
#include "Database.h"
using namespace std ;

void Database::add( const Record& record ) {
  records.push_back( record );
}

Record& Database::get( size_t i ) {
  return records.at( i ) ;
}

const Record& Database::get( size_t i ) const {
  return records.at( i ) ;
}

size_t Database::getSize() {
  return records.size() ;
}

void Database::insert( const Record& record, size_t i ) {
  records.insert( records.begin() + i, record ) ;
}

bool Database::load( const String& fileName ) {
  FILE* f = fopen( fileName.c_str(), "rb" ) ;
  if ( f ) {
    records.clear() ;
    Record record ;
    record.read( f );
    while ( !feof(f) && !ferror(f) ) {
      records.push_back( record );
      record.read( f );
    }
    fclose( f );
    return true ;
  }
  return false ;
  /*
  C++ fstream (bloated) version
  ifstream in( fileName.c_str(), ios::binary ) ;
  Record record ;
  if ( in ) {
    records.clear() ;
    while ( in >> record ) {
      records.push_back( record ) ;
    }
    return true ;
  }
  return false ;
  */
}

void Database::remove( size_t i ) {
  records.erase( records.begin() + i );
}

void Database::removeAll() {
  records.clear() ;
}

bool Database::save( const String& fileName ) const {
  FILE* f = fopen( fileName.c_str(), "wb" );
  if ( f ) {
    for ( size_t i = 0; i < records.size(); ++i ) {
      records[ i ].write( f ) ;
      fputc( '\r', f );
      fputc( '\n', f );
    }
    fclose( f );
    return true ;
  }
  return false ;
  /*
  C++ fstream (bloated) version
  ofstream out( fileName.c_str(), ios::binary ) ;
  if ( out.is_open() ) {
    for ( size_t i = 0; i < records.size(); ++i ) {
      out << records[ i ] << "\r\n" ;
    }
    return out.good() ;
  }
  return false ;
  */
}

void Database::sortAscending() {
  sort( records.begin(), records.end(), sortAscendingComp );
}

void Database::sortDescending() {
  sort( records.begin(), records.end(), sortDescendingComp );
}

bool Database::sortAscendingComp( const Record& a, const Record& b ) {
  return stricmp(a.getName().c_str(),b.getName().c_str()) < 0 ;
}

bool Database::sortDescendingComp( const Record& a, const Record& b ) {
  return stricmp(a.getName().c_str(),b.getName().c_str()) > 0 ;
}










