#ifndef COLORDIALOG_H
#define COLORDIALOG_H
#include <windows.h>

/**
  Class ColorDialog wraps the Win32 color dialog.
  The following lines show how to use the class.
  
  // Create a ColorDialog object.
  ColorDialog colorDialog ;
    
  // Show the modal Color dialog
  if ( colorDialog.show( hwndOwner ) ) {
    // OK button selected, get the selected color.
    COLORREF color = colorDialog.getColor() ;
  }
  else {
    // Cancel button selected
  }
 */
class ColorDialog {
public:

  /**
    Creates a new ColorDialog object with the specified selected color.
   */
  ColorDialog( COLORREF newColor = RGB(0,0,0) );
  
  /**
    Returns the selected color.
   */
  COLORREF getColor() const ;
  
  /**
    Returns the address of the array of custom colors.
   */
  COLORREF* getCustomColors() ;
  const COLORREF* getCustomColors() const ;
  
  /**
    Sets the selected color.
   */
  void setColor( COLORREF ) ;
  
  /**
    Displays the color dialog.
    Returns true if the user clicked OK; false otherwise.
   */
  bool show( HWND ) ;
private:
  COLORREF color ;
  COLORREF custColors[ 16 ] ;
};

#endif
