#include "ColorDialog.h"

//------------------------------------------------------------------------------
// ColorDialog Constructors and Destructors
//------------------------------------------------------------------------------

ColorDialog::ColorDialog( COLORREF newColor )
  : color( newColor) {
  ZeroMemory( custColors, sizeof(custColors) );
}

//------------------------------------------------------------------------------
// ColorDialog Member Functions
//------------------------------------------------------------------------------

COLORREF ColorDialog::getColor() const {
  return color ;
}

COLORREF* ColorDialog::getCustomColors() {
  return custColors ;
}

const COLORREF* ColorDialog::getCustomColors() const {
  return custColors ;
}

void ColorDialog::setColor( COLORREF newColor ) {
  color = newColor ;
}

bool ColorDialog::show( HWND hwndOwner ) {
  CHOOSECOLOR cc = { 0 } ;
  cc.lStructSize  = sizeof( cc ) ;
  cc.hwndOwner    = hwndOwner ;
  cc.rgbResult    = color ;
  cc.lpCustColors = custColors ;
  cc.Flags        = CC_RGBINIT | CC_ANYCOLOR | CC_FULLOPEN;
  if ( ChooseColor( &cc ) ) {
    color = cc.rgbResult ;
    return true ;
  }
  return false ;
}
