#include "Brush.h"

//------------------------------------------------------------------------------
// Brush Constructors and Destructors
//------------------------------------------------------------------------------

Brush::Brush( COLORREF firstColor )
  : hbrush( (HBRUSH)GetStockObject(BLACK_BRUSH) ) {
  createSolid( firstColor );
}

//------------------------------------------------------------------------------
// Brush Member Functions
//------------------------------------------------------------------------------

bool Brush::createSolid( COLORREF newColor ) {
  HBRUSH newBrush = CreateSolidBrush( newColor );
  if ( newBrush ) {
    free() ;
    hbrush = newBrush ;
    return true ;
  }
  return false ;
}

void Brush::free() {
  if ( hbrush ) {
    DeleteObject( hbrush ) ;
    hbrush = NULL ;
  }
}

COLORREF Brush::getColor() const {
  LOGBRUSH lb ;
  GetObject( hbrush, sizeof(lb), &lb );
  return lb.lbColor ;
}

HBRUSH Brush::getHandle() const {
  return hbrush ;
}
