#ifndef AL_WIN_GUI_WINEXCEPTION
#define AL_WIN_GUI_WINEXCEPTION
#include <windows.h>
#include <tchar.h>

class WindowsException {
public:
  WindowsException( const TCHAR* s = TEXT("") );
  WindowsException( const WindowsException& );
  virtual ~WindowsException() ;
  WindowsException& operator=( const WindowsException& );
  LPCTSTR getMessage() const ;
  void setMessage( LPCTSTR s );
private:
  TCHAR* msg ;
};

inline WindowsException::WindowsException( const TCHAR* s )
  : msg( NULL ) {
  setMessage( s );
}

inline WindowsException::WindowsException( const WindowsException& e )
  : msg( NULL ) {
  if ( this != &e ) {
    setMessage( e.msg );
  }
}

inline WindowsException& WindowsException::operator=(const WindowsException& e){
  if ( this != &e ) {
    setMessage( e.msg );
  }
  return *this ;
}

inline LPCTSTR WindowsException::getMessage() const {
  return this->msg ;
}

#endif
