#ifndef ANDREWLIM_WIN_GUI_WINDOW
#define ANDREWLIM_WIN_GUI_WINDOW
#include <windows.h>
#include "WindowCreationException.h"
#include "WinString.h"

class Window {
public:
  enum {
    LEFT = 1, TOP = 2, RIGHT = 4, BOTTOM = 8, ALL = LEFT | TOP | RIGHT | BOTTOM
  };
public:
  Window( HWND h = NULL );
  virtual ~Window();
  operator HWND() const ;
public:
  void addStyle(DWORD dwStyleToAdd );
  void centerInScreen() ;
  HWND createWindow( LPCTSTR lpClassName, LPCTSTR lpWindowName, DWORD dwStyle,
               int x, int y, int nWidth, int nHeight, HWND hWndParent,
               HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam );
  HWND createWindowEx( DWORD dwExStyle,
                 LPCTSTR lpClassName, LPCTSTR lpWindowName, DWORD dwStyle,
                 int x, int y, int nWidth, int nHeight, HWND hWndParent,
                 HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam ) ;
  void destroy() ;
  void disableMaxButton() ;
  void getClientSize( int& w, int& h ) const ;
  int getClientWidth() const ;
  int getClientHeight() const ;
  HFONT getFont() const ;
  HWND getHandle() const ;
  int getHeight() const ;
  POINT getLocation() const ;
  int getLeft() const ;
  HMENU getMenu() const ;
  Window getOwner() const ;
  Window getParent() const ;
  RECT getRectRelative( HWND hwnd );
  void getSize( int& w, int& h ) const;
  DWORD getStyle() const ;
  String& getText( String& text ) const ;
  void getText( LPTSTR lpString, int nMaxCount ) const ;
  int getTop() const ;
  int getWidth() const ;
  void invalidateRect( const RECT* lpRect, BOOL bErase );
  bool isEnabled() const;
  bool isVisible() const ;
  int messageBox( LPCTSTR lpText, LPCTSTR lpCaption, UINT uType );
  void removeStyle( DWORD dwStyleToRemove ) ;
  void removeThickFrame();
  LRESULT sendMessage( UINT msg, WPARAM w=0, LPARAM l=0 );
  void setClientHeight( int h );
  void setClientSize( int w, int h );
  void setClientWidth( int w );
  void setDefaultGuiFont() ;
  void setEnabled( bool b );
  void setFocus();
  void setFont( HFONT hFont, bool redraw=true );
  void setHandle( HWND hwnd );
  void setHeight( int h );
  void setIcon( WPARAM bigOrSmall, HICON hIcon );
  void setLeft( int left );
  void setLocation( int x, int y );
  void setLocationRelative( HWND hwndRelative, int dir, int dist );
  void setMargins( RECT* margins, UINT flags = ALL );
  void setRedraw( bool b );
  void setSize( int w, int h );
  void setStyle( DWORD style );
  void setText( LPCTSTR text );
  void setTop( int top );
  void setVisible( bool b );
  void setWidth( int w );
  LONG_PTR setWindowLongPtr( int nIndex, LONG_PTR  dwNewLong );
  void show( int nCmdShow = SW_SHOW );
  void toggleEnabled();
  void toggleVisible();
private:
  HWND hwnd ;
};


inline Window::Window( HWND h )
  :hwnd(h) {
}

inline Window::~Window() {
}

inline Window::operator HWND() const {
  return hwnd ;
}

inline HWND Window::createWindow( LPCTSTR lpClassName, LPCTSTR lpWindowName,
                            DWORD dwStyle, int x, int y, int nWidth,
                            int nHeight, HWND hWndParent, HMENU hMenu,
                            HINSTANCE hInstance, LPVOID lpParam ) {
  return (hwnd = ::CreateWindow( lpClassName, lpWindowName, dwStyle, x, y,
                                 nWidth, nHeight, hWndParent, hMenu, hInstance,
                                 lpParam ) ) ;
}

inline HWND Window::createWindowEx( DWORD dwExStyle, LPCTSTR lpClassName,
                              LPCTSTR lpWindowName, DWORD dwStyle, int x, int y,
                              int nWidth, int nHeight, HWND hWndParent,
                              HMENU hMenu, HINSTANCE hInstance,
                              LPVOID lpParam ) {
  return (hwnd = ::CreateWindowEx( dwExStyle, lpClassName, lpWindowName,
                                   dwStyle, x, y, nWidth, nHeight, hWndParent,
                                   hMenu, hInstance, lpParam ) );
}

inline void Window::disableMaxButton() {
  removeStyle( WS_MAXIMIZEBOX );
}

inline HFONT Window::getFont() const {
  return (HFONT)::SendMessage( hwnd, WM_GETFONT, 0, 0 );
}

inline HWND Window::getHandle() const {
  return hwnd ;
}

inline int Window::getLeft() const {
  return getLocation().x ;
}

inline HMENU Window::getMenu() const {
  return ::GetMenu( hwnd );
}

inline Window Window::getOwner() const {
  return ::GetWindow( hwnd, GW_OWNER );
}

inline Window Window::getParent() const {
  return GetParent(hwnd) ;
}

inline DWORD Window::getStyle() const {
  return GetWindowLong(hwnd,GWL_STYLE) ;
}

inline int Window::getTop() const {
  return getLocation().y ;
}

inline void Window::invalidateRect( const RECT* lpRect, BOOL bErase ) {
  ::InvalidateRect( hwnd, lpRect, bErase );
}

inline bool Window::isEnabled() const {
  return ::IsWindowEnabled( hwnd );
}

inline bool Window::isVisible() const {
  return ::IsWindowVisible( hwnd );
}

inline int Window::messageBox( LPCTSTR lpText, LPCTSTR lpCaption, UINT uType ) {
  return ::MessageBox( hwnd, lpText, lpCaption, uType );
}

inline void Window::removeThickFrame() {
  removeStyle( WS_THICKFRAME );
}

inline LRESULT Window::sendMessage( UINT msg, WPARAM w, LPARAM l ) {
  return ::SendMessage( hwnd, msg, w, l );
}

inline void Window::setClientHeight( int h ) {
  setClientSize( getClientWidth(), h );
}

inline void Window::setClientWidth( int w ) {
  setClientSize( w, getClientHeight() );
}

inline void Window::setDefaultGuiFont() {
  sendMessage( WM_SETFONT, (WPARAM)GetStockObject(DEFAULT_GUI_FONT), 0  );
}

inline void Window::setEnabled( bool b ) {
  ::EnableWindow( hwnd, b ? TRUE : FALSE );
}

inline void Window::setFocus() {
  ::SetFocus( hwnd );
}

inline void Window::setFont( HFONT hFont, bool redraw ) {
  ::SendMessage(hwnd,WM_SETFONT,(WPARAM)hFont, MAKELPARAM(redraw?TRUE:FALSE,0));
}

inline void Window::setHandle( HWND hwnd ) {
  this->hwnd = hwnd ;
}

inline void Window::setHeight( int h ) {
  setSize( getWidth(), h );
}

inline void Window::setIcon( WPARAM bigOrSmall, HICON icon ) {
  ::SendMessage( hwnd, WM_SETICON, (WPARAM) bigOrSmall, (LPARAM) icon );
}

inline void Window::setLocation( int x, int y ) {
  ::SetWindowPos( hwnd, NULL, x, y, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
}

inline void Window::setLeft( int left ) {
  setLocation( left, getLocation().y );
}

inline void Window::setRedraw( bool b ) {
  ::SendMessage( hwnd, WM_SETREDRAW, b?TRUE:FALSE, 0 );
}

inline void Window::setSize( int w, int h ) {
  ::SetWindowPos( hwnd, NULL, 0, 0, w, h, SWP_NOMOVE|SWP_NOZORDER );
}

inline void Window::setText( LPCTSTR text ) {
  ::SetWindowText( hwnd, text );
}

inline void Window::setTop( int top ) {
  setLocation( getLocation().x, top );
}

inline void Window::setVisible( bool b ) {
  ::ShowWindow( hwnd, b ? SW_SHOW : SW_HIDE );
}

inline void Window::setWidth( int w ) {
  setSize( w, getHeight() );
}

inline LONG_PTR Window::setWindowLongPtr( int nIndex, LONG_PTR dwNewLong ) {
  return ::SetWindowLongPtr( hwnd, nIndex, dwNewLong );
}

inline void Window::show( int nCmdShow ) {
  ::ShowWindow( hwnd, nCmdShow );
}

inline void Window::toggleEnabled() {
  setEnabled( !isEnabled() );
}

inline void Window::toggleVisible() {
  ::ShowWindow( hwnd, IsWindowVisible(hwnd) ? SW_HIDE : SW_SHOW );
}

#endif
