#include "Window.h"



//------------------------------------------------------------------------------
// Constructors and Destructors
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Operators
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Public Member Functions
//------------------------------------------------------------------------------

void Window::addStyle( DWORD dwStyleToAdd ) {
  SetWindowLong(hwnd,GWL_STYLE,GetWindowLong(hwnd,GWL_STYLE)|dwStyleToAdd);
  SetWindowPos(hwnd,0,0,0,0,0,SWP_NOZORDER|SWP_NOSIZE|SWP_NOMOVE);
}

void Window::centerInScreen() {
  if ( NULL != hwnd ) {
    RECT rc = { 0 };
    GetWindowRect ( hwnd, &rc ) ;
    SetWindowPos( hwnd, 0,
                  (GetSystemMetrics(SM_CXSCREEN) - (rc.right-rc.left))/2,
                  (GetSystemMetrics(SM_CYSCREEN) - (rc.bottom-rc.top))/2,
                  0, 0, SWP_NOZORDER|SWP_NOSIZE );
  }
}

void Window::destroy() {
  if ( hwnd != NULL ) {
    DestroyWindow( hwnd );
    hwnd = NULL ;
  }
}

void Window::getClientSize( int& w, int& h ) const {
  RECT rc = { 0 } ;
  GetClientRect( hwnd, &rc );
  w = rc.right - rc.left ;
  h = rc.bottom - rc.top ;
}

int Window::getClientWidth() const {
  RECT rc = { 0 } ;
  GetClientRect( hwnd, &rc );
  return rc.right - rc.left ;
}

int Window::getClientHeight() const {
  RECT rc = { 0 } ;
  GetClientRect( hwnd, &rc );
  return rc.bottom - rc.top ;
}

int Window::getHeight() const {
  RECT rc = { 0 } ;
  GetWindowRect( hwnd, &rc );
  return rc.bottom - rc.top ;
}

POINT Window::getLocation() const {
  RECT rc = { 0 } ;
  GetWindowRect( hwnd, &rc );
  MapWindowPoints( NULL, GetParent(hwnd), (POINT*) &rc, 2 );
  POINT location = { rc.left, rc.top } ;
  return location ;
}

RECT Window::getRectRelative( HWND hwndRelative ) {
  RECT rc = { 0 } ;
  GetWindowRect( hwnd, &rc );
  MapWindowPoints( NULL, hwndRelative, (POINT*) &rc, 2 );
  return rc ;
}

void Window::getSize( int& w, int& h ) const {
  RECT rc = { 0 } ;
  GetWindowRect( hwnd, &rc );
  w = rc.right - rc.left ;
  h = rc.bottom - rc.top ;
}

String& Window::getText( String& text ) const {
  if ( NULL != hwnd ) {
    int len = GetWindowTextLength( hwnd );
    if ( len > 0 ) {
      TCHAR* buf = (TCHAR*)HeapAlloc(GetProcessHeap(),0,sizeof(TCHAR)*(len+1));
      if ( NULL != buf ) {
        GetWindowText( hwnd, buf, len + 1 );
        text = buf ;
        HeapFree( GetProcessHeap(), 0, buf );
      }
    }
  }
  return text;
}

int Window::getWidth() const {
  RECT rc = { 0 } ;
  GetWindowRect( hwnd, &rc );
  return rc.right - rc.left ;
}

void Window::removeStyle( DWORD dwStyleToRemove ) {
  SetWindowLong(hwnd,GWL_STYLE,GetWindowLong(hwnd,GWL_STYLE)&~dwStyleToRemove);
  SetWindowPos(hwnd,0,0,0,0,0,SWP_NOZORDER|SWP_NOSIZE|SWP_NOMOVE );
}



void Window::setClientSize( int clientWidth, int clientHeight ) {
  if ( IsWindow( hwnd ) ) {
    DWORD dwStyle = GetWindowLongPtr( hwnd, GWL_STYLE ) ;
    DWORD dwExStyle = GetWindowLongPtr( hwnd, GWL_EXSTYLE ) ;
    HMENU menu = GetMenu( hwnd ) ;
    RECT rc = {0};
    rc.right = clientWidth ;
    rc.bottom = clientHeight ;
    AdjustWindowRectEx( &rc, dwStyle, menu ? TRUE : FALSE, dwExStyle );
    SetWindowPos( hwnd, NULL, 0, 0, rc.right - rc.left, rc.bottom - rc.top,
                  SWP_NOZORDER | SWP_NOMOVE ) ;
  }
}

void Window::setLocationRelative( HWND hwndRelative, int dir, int dist ) {
  RECT rc, rcRelative ;
  ::GetWindowRect( hwnd, &rc );
  ::GetWindowRect( hwndRelative, &rcRelative );

  HWND parent = ::GetParent( hwnd );
  ::MapWindowPoints( NULL, parent, (LPPOINT)(void*)&rc, 2 );
  ::MapWindowPoints( NULL, parent, (LPPOINT)(void*)&rcRelative, 2 );

  int windowX = rc.left ;
  int windowY = rc.top ;

  const int windowW = rc.right - rc.left ;
  const int windowH = rc.bottom - rc.top ;
  const int relativeX = rcRelative.left ;
  const int relativeY = rcRelative.top ;
  const int relativeW = rcRelative.right - rcRelative.left ;
  const int relativeH = rcRelative.bottom - rcRelative.top ;

  switch ( dir ) {
    case LEFT:   windowX = relativeX - windowW - dist ;   break ;
    case TOP:    windowY = relativeY - windowH - dist ;   break ;
    case RIGHT:  windowX = relativeX + relativeW + dist ; break ;
    case BOTTOM: windowY = relativeY + relativeH + dist ; break ;
  }

  ::SetWindowPos( hwnd, NULL, windowX, windowY, 0, 0, SWP_NOSIZE|SWP_NOZORDER );
}

void Window::setMargins( RECT* margins, UINT flags ) {
  if ( hwnd != NULL && margins != NULL ) {
    HWND hwndParent = GetParent( hwnd );
    if ( hwndParent != NULL ) {
      // Get window dimensions relative to its parent.
      RECT rcWindow ;
      GetWindowRect( hwnd, &rcWindow );
      MapWindowPoints( NULL, hwndParent, (LPPOINT)(void*)&rcWindow, 2 );

      // Get parent's client dimensions.
      RECT rcParentClient ;
      GetClientRect( GetParent(hwnd), &rcParentClient );
      int parentClientWidth = rcParentClient.right - rcParentClient.left ;
      int parentClientHeight = rcParentClient.bottom - rcParentClient.top ;

      // Values that would maintain window's current dimensions.
      int x = rcWindow.left,
          y = rcWindow.top,
          w = rcWindow.right-rcWindow.left,
          h = rcWindow.bottom-rcWindow.top ;

      // Check which flags for which margins have been set, and modify the
      // above values accordingly.
      if ( flags & LEFT ) {
        x = margins->left ;
      }
      if ( flags & TOP ) {
        y = margins->top ;
      }
      if ( flags & RIGHT ) {
        w = parentClientWidth - x - margins->right ;
      }
      if ( flags & BOTTOM ) {
        h = parentClientHeight - y - margins->bottom ;
      }

      // Set the window's new dimensions to fit the given margins.
      SetWindowPos( hwnd, NULL, x, y, w, h, SWP_NOZORDER );
    }
  }
}

void Window::setStyle( DWORD style ) {
  SetWindowLong(hwnd,GWL_STYLE,style);
  SetWindowPos(hwnd,0,0,0,0,0,SWP_NOZORDER|SWP_NOSIZE|SWP_NOMOVE);
}



//------------------------------------------------------------------------------
// Private Member Functions
//------------------------------------------------------------------------------
