#ifndef ANDREWLIM_WIN_GUI_TEXTBOX
#define ANDREWLIM_WIN_GUI_TEXTBOX

#include "Window.h"

class TextBox : public Window {
public:
  static const int NOTEPAD_STYLE = WS_CHILD|ES_WANTRETURN|ES_MULTILINE|
                                   ES_AUTOHSCROLL|ES_AUTOVSCROLL|
                                   WS_VSCROLL|WS_HSCROLL|WS_VISIBLE;
public:
  TextBox( HWND hwndParent, DWORD dwStyle, DWORD dwExStyle );
  ~TextBox();
private:
  TextBox( const TextBox& );
  TextBox& operator=( const TextBox& );
public:
  void copy() ;
  void paste() ;
  void selectAll();
  void setLimitText( int );
  void setReadOnly( bool b );
  static void selectAll( HWND hwnd );
};

inline TextBox::TextBox( HWND hwndParent, DWORD dwStyle, DWORD dwExStyle ) {
  if ( createWindowEx( dwExStyle, TEXT("EDIT"), TEXT(""), dwStyle, 0,0,0,0,
                       hwndParent, 0, GetModuleHandle(NULL), 0 ) == NULL ) {
    throw WindowCreationException( TEXT("Error creating TextBox") );
  }
}

inline TextBox::~TextBox() {
  destroy() ;
}

inline void TextBox::copy() {
  SendMessage( *this, WM_COPY, 0, -1 ) ;
}

inline void TextBox::paste() {
  SendMessage( *this, WM_PASTE, 0, -1 ) ;
}

inline void TextBox::selectAll() {
  SendMessage( *this, EM_SETSEL, 0, -1 ) ;
}

inline void TextBox::setLimitText( int limit ) {
  sendMessage( EM_LIMITTEXT, limit, 0 );
}

inline void TextBox::setReadOnly( bool b ) {
  sendMessage( EM_SETREADONLY, b ? TRUE : FALSE );
}

inline void TextBox::selectAll( HWND h ) {
  ::SendMessage( h, EM_SETSEL, 0, -1 ) ;
}

#endif
