#ifndef ANDREWLIM_WIN_GUI_SPLITTER
#define ANDREWLIM_WIN_GUI_SPLITTER
#include "CustomWindow.h"

class Splitter : public CustomWindow {
public:
  class Listener {
  public:
    virtual ~Listener() {}
    virtual void onMove( Splitter& ) = 0 ;
  };
public:
  Splitter( HWND hwndParent );
  ~Splitter();
  virtual LRESULT onMessage( UINT msg, WPARAM wParam, LPARAM lParam );
  void setSplitterListener( Splitter::Listener& splitterListener );
  COLORREF getColor() const ;
  Splitter::Listener* getSplitterListener() ;
  bool isHorizontal() const ;
  void setColor( COLORREF color );
  void setHorizontal( bool b ) ;
private:
  LRESULT onLButtonDown( WPARAM wParam, LPARAM lParam );
  LRESULT onLButtonUp( WPARAM wParam, LPARAM lParam );
  LRESULT onMouseMove( WPARAM wParam, LPARAM lParam );
  LRESULT onPaint( WPARAM wParam, LPARAM lParam );
  Splitter::Listener* splitterListener ;
  bool horizontal ;
  COLORREF color ;
  Splitter( const Splitter& );
  Splitter& operator=( const Splitter& );
};

inline Splitter::Splitter( HWND hwndParent )
  : CustomWindow( TEXT(""), hwndParent, WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS, 0)
  , splitterListener( NULL )
  , horizontal( false )
  , color( GetSysColor(COLOR_3DFACE) ) {
}

inline Splitter::~Splitter() {
  destroy();
}

inline COLORREF Splitter::getColor() const {
  return color ;
}

inline Splitter::Listener* Splitter::getSplitterListener() {
  return splitterListener ;
}

inline bool Splitter::isHorizontal() const {
  return horizontal ;
}

inline void Splitter::setHorizontal( bool horizontal ){
  this->horizontal = horizontal ;
}

inline void Splitter::setColor( COLORREF color ) {
  this->color = color ;
}

inline void Splitter::setSplitterListener(Splitter::Listener& splitterListener){
  this->splitterListener = &splitterListener ;
}

#endif
