#include "Splitter.h"



LRESULT Splitter::onLButtonDown( WPARAM wParam, LPARAM lParam ) {
  SetCapture( getHandle() );
  SetCursor( LoadCursor(0,IDC_SIZEWE) );
  return 0 ;
}

LRESULT Splitter::onLButtonUp( WPARAM wParam, LPARAM lParam ) {
  if ( getHandle() == GetCapture() ) {
    ReleaseCapture();
  }
  return 0 ;
}

LRESULT Splitter::onMouseMove( WPARAM wParam, LPARAM lParam ) {
  HWND hwnd = getHandle() ;
  SetCursor( LoadCursor(0,IDC_SIZEWE) );
  if ( hwnd == GetCapture() ) {
    // Save current location
    POINT currentLocation = getLocation() ;

    // Calculate new location based on mouse coordinates.
    POINT newLocation ;
    GetCursorPos( &newLocation );
    MapWindowPoints( NULL, getParent(), &newLocation, 1 );

    // Get parent's client size
    int parentClientWidth, parentClientHeight ;
    getParent().getClientSize( parentClientWidth, parentClientHeight );

    // Get splitter's size
    int splitterWidth, splitterHeight ;
    getSize( splitterWidth, splitterHeight );

    // If mouse coordinates lie outside parent's client area, wrap the
    // values.
    const int MAX_LEFT = 0 ;
    const int MAX_RIGHT = parentClientWidth-splitterWidth ;
    const int MAX_TOP = 0 ;
    const int MAX_BOTTOM = parentClientHeight - splitterHeight ;
    if ( newLocation.x > MAX_RIGHT ) {
      newLocation.x = MAX_RIGHT ;
    }
    if ( newLocation.x <= MAX_LEFT ) {
      newLocation.x = MAX_LEFT ;
    }
    if ( newLocation.y > MAX_BOTTOM ) {
      newLocation.y = MAX_BOTTOM ;
    }
    if ( newLocation.y <= MAX_TOP ) {
      newLocation.y = MAX_TOP ;
    }

    // If new location is not the same as the old location, change splitter
    // location to new location.
    if ( horizontal ) {
      if ( currentLocation.y != newLocation.y ) {
        setTop( newLocation.y );
        if ( NULL != splitterListener ) {
          splitterListener->onMove( *this );
        }
      }
    }
    else {
      if ( currentLocation.x != newLocation.x ) {
        setLeft( newLocation.x );
        if ( NULL != splitterListener ) {
          splitterListener->onMove( *this );
        }
      }
    }
  }
  return 0 ;
}

LRESULT Splitter::onPaint( WPARAM wParam, LPARAM lParam ) {
  PAINTSTRUCT ps ;
  HDC hdc = BeginPaint( *this, &ps );

  int clientWidth, clientHeight ;
  getClientSize( clientWidth, clientHeight );
  RECT rc = { 0, 0, clientWidth, clientHeight };

  HBRUSH brush = CreateSolidBrush( color );
  FillRect( hdc, &rc, brush );
  DeleteObject( brush );

  EndPaint( *this, &ps );
  return 0 ;
}

LRESULT Splitter::onMessage( UINT msg, WPARAM wParam, LPARAM lParam ) {
  switch ( msg ) {
    case WM_MOUSEMOVE:   return onMouseMove( wParam, lParam );
    case WM_LBUTTONDOWN: return onLButtonDown( wParam, lParam );
    case WM_LBUTTONUP:   return onLButtonUp( wParam, lParam );
    case WM_PAINT:       return onPaint( wParam, lParam );
    default:             return CustomWindow::onMessage( msg, wParam, lParam );
  }
}
