#ifndef RECORD_BOOK_SETTINGS_H
#define RECORD_BOOK_SETTINGS_H
#include <windows.h>
#include <deque>
#include "WinString.h"
#include "Brush.h"
class Settings {
public:
  static const String FONT_NAME_DEFAULT ;
  static const int RECENT_FILES_MAX_DEFAULT = 10 ;
public:
  String fontName ;
  long   fontSize ;
  bool   fontBold, fontItalic ;
  Brush  colorBrush, backgroundColorBrush ;
  long   splitterX ;
  bool   windowMaximized ;
  long   windowX, windowY, windowWidth, windowHeight ;
  std::deque< std::basic_string<TCHAR> > recentFiles ;
  long   recentFilesMax ;
  Settings()
  : fontName( FONT_NAME_DEFAULT )
  , fontSize(10), fontBold(false), fontItalic(false)
  , colorBrush( RGB(255,255,255) )
  , splitterX( 100 )
  , windowMaximized( true )
  , windowX( 0 ), windowY( 0 ), windowWidth( 640 ), windowHeight( 480 )
  , recentFilesMax(RECENT_FILES_MAX_DEFAULT) {
  }
  bool load( const String& filePath ) ;
  bool save( const String& filePath ) const ;
};
#endif

