#include "Settings.h"
#include "Notebook.h"
#include "ConvertUtils.h"
#include <tchar.h>

const String Settings::FONT_NAME_DEFAULT = _T("Courier New") ;

bool Settings::load( const String& filePath ) {
  Notebook settingsBook ;
  if ( !settingsBook.openFile( filePath ) ) {
    return false ;
  }

  fontName = FONT_NAME_DEFAULT ;
  Note* fontNameNote = settingsBook.get( _T("fontName") );
  if ( fontNameNote && !fontNameNote->value.empty() ) {
    fontName = fontNameNote->value ;
  }

  Note* fontSizeNote = settingsBook.get( _T("fontSize") );
  if ( fontSizeNote ) {
    ConvertUtils::stringToInt( fontSizeNote->value, fontSize, 10 );
  }

  Note* fontBoldNote = settingsBook.get( _T("fontBold") );
  if ( fontBoldNote ) {
    fontBold = fontBoldNote->value == _T("true") ;
  }

  Note* fontItalicNote = settingsBook.get( _T("fontItalic") );
  if ( fontItalicNote ) {
    fontItalic = fontItalicNote->value == _T("true") ;
  }

  Note* colorNote = settingsBook.get( _T("color") );
  if ( colorNote ) {
    LONG color = 0 ;
    ConvertUtils::stringToInt(colorNote->value,color,RGB(255,255,25) ) ;
    colorBrush.createSolid( color );
  }

  Note* backgroundColorNote = settingsBook.get( _T("backgroundColor") );
  if ( backgroundColorNote ) {
    LONG backgroundColor = 0 ;
    ConvertUtils::stringToInt(backgroundColorNote->value,backgroundColor,RGB(0,0,0) ) ;
    backgroundColorBrush.createSolid( backgroundColor );
  }

  Note* splitterXNote = settingsBook.get( _T("splitterX") );
  if ( splitterXNote ) {
    ConvertUtils::stringToInt(splitterXNote->value, splitterX, 100 ) ;
  }

  Note* windowXNote = settingsBook.get( _T("windowX") );
  Note* windowYNote = settingsBook.get( _T("windowY") );
  Note* windowWidthNote = settingsBook.get( _T("windowWidth") );
  Note* windowHeightNote = settingsBook.get( _T("windowHeight") );
  Note* windowMaximizedNote = settingsBook.get( _T("windowMaximized") );
  if ( windowXNote ) {
    ConvertUtils::stringToInt(windowXNote->value,windowX, 0 ) ;
  }
  if ( windowYNote ) {
    ConvertUtils::stringToInt(windowYNote->value,windowY, 0 ) ;
  }
  if ( windowWidthNote ) {
    ConvertUtils::stringToInt(windowWidthNote->value,windowWidth, 400 ) ;
  }
  if ( windowHeightNote ) {
    ConvertUtils::stringToInt(windowHeightNote->value,windowHeight, 300 ) ;
  }
  if ( windowMaximizedNote ) {
    windowMaximized = windowMaximizedNote->value == _T("true");
  }

  Note* recentFilesNote = settingsBook.get( _T("recentFiles") );
  if ( recentFilesNote ) {
    String recentFilesValue = recentFilesNote->value ;
    String recentFile ;
    for ( size_t i=0; i<recentFilesValue.size(); ++i ) {
      TCHAR c = recentFilesValue[ i ];
      if ( c == '\n' || c == '\r' ) {
        if ( !recentFile.empty() ) {
          recentFiles.push_back( recentFile );
          recentFile.clear();
        }
      } else {
        recentFile += c ;
      }
    }
  }

  Note* recentFilesMaxNote = settingsBook.get( _T("recentFilesMax") );
  if ( recentFilesMaxNote ) {
    ConvertUtils::stringToInt( recentFilesMaxNote->value, recentFilesMax,
                               RECENT_FILES_MAX_DEFAULT ) ;

    if ( recentFilesMax < 0 ) {
      recentFilesMax = RECENT_FILES_MAX_DEFAULT ;
    }
  }

  return true ;
}

bool Settings::save( const String& filePath ) const  {
  Notebook settingsBook ;
  settingsBook.put( Note(_T("fontName"), fontName) );
  settingsBook.put( Note(_T("fontSize"), ConvertUtils::intToString(fontSize) ) );
  settingsBook.put( Note(_T("fontBold"), fontBold ? _T("true") : _T("false") ) );
  settingsBook.put( Note(_T("fontItalic"), fontItalic ? _T("true") : _T("false") ) );
  settingsBook.put( Note(_T("color"), ConvertUtils::intToString(colorBrush.getColor()) ) );
  settingsBook.put( Note(_T("backgroundColor"), ConvertUtils::intToString(backgroundColorBrush.getColor()) ) );
  settingsBook.put( Note(_T("splitterX"), ConvertUtils::intToString(splitterX) ) );
  settingsBook.put( Note(_T("windowMaximized"), windowMaximized ? _T("true") : _T("false") ) );
  settingsBook.put( Note(_T("windowX"), ConvertUtils::intToString(windowX) ) );
  settingsBook.put( Note(_T("windowY"), ConvertUtils::intToString(windowY) ) );
  settingsBook.put( Note(_T("windowWidth"), ConvertUtils::intToString(windowWidth) ) );
  settingsBook.put( Note(_T("windowHeight"), ConvertUtils::intToString(windowHeight) ) );
  settingsBook.put( Note(_T("recentFilesMax"), ConvertUtils::intToString(recentFilesMax) ) );
  String recentFilesValue ;
  for ( size_t i=0; i<recentFiles.size(); ++i ) {
    recentFilesValue += recentFiles[i] ;
    recentFilesValue += '\n';
  }
  settingsBook.put( Note(_T("recentFiles"), recentFilesValue ) );
  if ( !settingsBook.saveFile( filePath ) ) {
    return false ;
  }
  return true ;
}
