#ifndef ANDREW_LIM_NOTEBOOK_H
#define ANDREW_LIM_NOTEBOOK_H
#include "Note.h"
#include <map>
#include <vector>

class Notebook {
public:
  std::map< TString, Note > notes ;
public:
  void put( const Note& note );
  void remove( const TString& name );
  void rename( const TString& name, const TString& newName );
  Note* get( const TString& name );
  bool saveFile( const TString& filename );
  bool openFile( const TString& filename );
  size_t search(const TString& substring, std::vector<TString>& keys);
  static TString& toUpperCase( const TString& in, TString& out );
};

#endif

