#include "NoteTokener.h"
#include "textfile.h"

void Notebook::put( const Note& note ) {
  notes[ note.name ] = note ;
}

void Notebook::remove( const TString& name ) {
  if ( get( name ) ) {
    notes.erase( name );
  }
}

Note* Notebook::get( const TString& name ) {
  std::map< TString, Note >::iterator iter = notes.find( name ) ;
  if ( iter == notes.end() ) {
    return 0 ;
  }
  return &(iter->second) ;
}

void Notebook::rename( const TString& name, const TString& newName ) {
  if ( get( name ) && (name != newName) ) {
    notes[ newName ] = notes[ name ] ;
    notes.erase( name );
  }
}

bool Notebook::saveFile( const TString& name ) {
  CTextFileWrite f( name.c_str(), CTextFileWrite::UTF_8 );
  if ( !f.IsOpen() ) {
    return false ;
  }
  for ( map<TString,Note>::iterator i=notes.begin(); i!=notes.end(); ++i ){
    Note& note = i->second ;
    f.Write( note.toString() );
    f.Write( _T("\r\n") );
  }
  f.Close();
  return true ;
}

size_t Notebook::
search(const TString& substring, std::vector<TString>& keys) {
  keys.clear();
  for ( std::map< TString, Note >::iterator i=notes.begin();
        i!= notes.end();
        ++i ) {
    const TString& key = i->first ;
    const TString& val = i->second.value ;

    TString key2, val2, substring2 ;
    toUpperCase(key,key2) ;
    toUpperCase(val,val2) ;
    toUpperCase(substring,substring2) ;

    if ( key2.find(substring2) != TString::npos ) {
      keys.push_back( key );
    }
    else if ( val2.find(substring2) != TString::npos ) {
      keys.push_back( key );
    }
  }
  return keys.size();
}

TString& Notebook::toUpperCase( const TString& in, TString& out ) {
  out.reserve( in.size() );
  out.clear();
  for ( size_t i=0; i<in.size(); ++i ) {
    out += towupper( in[i] );
  }
  return out ;
}

bool Notebook::openFile( const TString& filename ) {
  CTextFileRead f( filename.c_str() );
  if ( !f.IsOpen() ) {
    return false ;
  }
  TString all ;
  f.Read( all );
  NoteTokener tokener( all ) ;
  return tokener.nextNotebook( *this );
}
