#include "NoteTokener.h"

NoteTokener::NoteTokener( const std::basic_string<TCHAR> & s )
: s(s)
, index( -1 ) {
}

TCHAR NoteTokener::next() {
  if ( more() ) {
    return s[ ++index ];
  }
  return 0 ;
}
TCHAR NoteTokener::nextClean() {
  for (;;) {
    TCHAR c = next() ;
    if ( c == 0 || !_istspace(c) ) {
      return c ;
    }
  }
}

bool NoteTokener::more() const {
  return index < (int) s.size() ;
}

void NoteTokener::back() {
  if ( index >= 0 ) {
    index-- ;
  }
}

bool NoteTokener::nextOpenBrace() {
  for( TCHAR c = nextClean(); more(); c =next() ) {
    if ( c == _T('{') ) {
      return true ;
    }
  }
  return false ;
}

bool NoteTokener::nextName( std::basic_string<TCHAR> & name ) {
  for( TCHAR c = next(); more(); c =next() ) {
    if ( c == _T('=') ) {
      back() ;
      name = unescapeString( name );
      return true ;
    }
    name += c ;
  }
  return false ;
}

bool NoteTokener::nextEqual() {
  for( TCHAR c = nextClean(); more(); c =next() ) {
    if ( c == _T('=') ) {
      return true ;
    }
  }
  return false ;
}

bool NoteTokener::nextValue( std::basic_string<TCHAR> & value ) {
  for( TCHAR c = next(); more(); c =next() ) {
    if ( c == _T('}') ) {
      back() ;
      value = unescapeString( value );
      return true ;
    }
    value += c ;
  }
  return false ;
}

bool NoteTokener::nextCloseBrace() {
  for( TCHAR c = nextClean(); more(); c =next() ) {
    if ( c == _T('}') ) {
      return true ;
    }
  }
  return false ;
}

bool NoteTokener::nextNotebook( Notebook& notebook ) {
  notebook.notes.clear();
  Note note ;
  while( nextNote(note) ) {
    notebook.put( note );
  }
  return true ;
}

bool NoteTokener::nextNote( Note& note ) {
  note.name = note.value = TEXT("" );
  if ( !nextOpenBrace() ) {
    return false ;
  }
  if ( !nextName(note.name) ) {
    return false ;
  }
  if ( !nextEqual() ) {
    return false ;
  }
  if ( !nextValue(note.value) ) {
    return false ;
  }
  if ( !nextCloseBrace() ) {
    return false ;
  }
  return true ;
}

TString NoteTokener::escapeString( const TString& s ) {
  TString s2 ;
  s2.reserve( s.size() );
  for ( size_t i = 0; i < s.size(); ++i ) {
    const wchar_t c = s[ i ] ;
    switch ( c ) {
      case _T('\\'): s2 += _T("\\\\") ; continue ;
      case _T('{'): s2 += _T("\\o") ;  continue ;
      case _T('}'): s2 += _T("\\c") ;  continue ;
      default:   s2 += c ;      continue ;
    }
  }
  return s2 ;
}

TString NoteTokener::unescapeString( const TString& s ) {
  TString s2 ;
  s2.reserve( s.size() );
  for ( size_t i = 0; i < s.size(); ++i ) {
    const wchar_t curr = s[ i ] ;
    if ( curr == _T('\\') && i+1 != s.size() ) {
      const wchar_t next = s[ i + 1 ] ;
      switch ( next ) {
        case _T('\\'): s2 += _T("\\") ; ++i ; continue ;
        case _T('o') : s2 += _T("{")  ; ++i ; continue ;
        case _T('c') : s2 += _T("}")  ; ++i ; continue ;
      }
    }
    else {
      s2 += curr ;
    }
  }
  return s2 ;
}
