#include "Note.h"
#include "NoteTokener.h"

Note::Note( const TString& name, const TString& value )
: name( name )
, value( value ){
}

TString Note::toString() const {
  TString r( _T("{") );
  r += NoteTokener::escapeString( name );
  r += _T('=') ;
  r += NoteTokener::escapeString( value );
  r += _T('}') ;
  return r ;
}


bool Note::parseNote( const TString& s, Note& note ) {
  NoteTokener tokener( s );
  return tokener.nextNote( note );
}
