#ifndef ANDREWLIM_GUI_MENU_H
#define ANDREWLIM_GUI_MENU_H
#include <windows.h>

class Menu {
public:
  Menu( bool makeMenuBar = false );
  virtual ~Menu();
  operator HMENU() const;
  void add( LPCTSTR itemText, int id ) ;
  void add( const Menu& menu, LPCTSTR text ) ;
  void addSeparator() ;
  void attachToWindow( HWND hwnd );
  Menu& createMenu();
  Menu& createPopupMenu();
  void destroy() ;
  int  itemCount() const ;
  void removeById( UINT );
  void removeByPosition( UINT );
  void setMenuItemChecked( int id, bool state );
  void setMenuItemEnabled( int id, bool state ) ;
private:
  HMENU hMenu ;
};

inline Menu::Menu( bool makeMenuBar )
  : hMenu( makeMenuBar ? CreateMenu() : CreatePopupMenu() ) {
}

inline Menu::~Menu() {
}

inline Menu::operator HMENU() const {
  return hMenu;
}

inline void Menu::add( LPCTSTR itemText, int id )  {
  ::AppendMenu( hMenu,
                MF_STRING,
                id,
                itemText );
}

inline void Menu::add( const Menu& menu, LPCTSTR text ) {
  ::AppendMenu( hMenu,
                MF_POPUP,
                reinterpret_cast<UINT_PTR>(menu.hMenu),
                text );
}

inline void Menu::addSeparator() {
  ::AppendMenu( hMenu, MF_SEPARATOR, 0, 0 );
}

inline void Menu::attachToWindow( HWND hwnd ) {
  ::SetMenu( hwnd, hMenu );
}


inline Menu& Menu::createMenu() {
  hMenu = ::CreateMenu() ;
  return *this ;
}

inline Menu& Menu::createPopupMenu() {
  hMenu = ::CreatePopupMenu() ;
  return *this ;
}

inline void Menu::destroy() {
  if ( NULL != hMenu ) {
    ::DestroyMenu( hMenu ) ;
    hMenu = NULL ;
  }
}

inline int Menu::itemCount() const {
  return ::GetMenuItemCount( hMenu );
}

inline void Menu::removeById( UINT id ) {
  ::DeleteMenu( hMenu, id, MF_BYCOMMAND);
}

inline void Menu::removeByPosition( UINT pos ) {
  ::DeleteMenu( hMenu, pos, MF_BYPOSITION );
}

inline void Menu::setMenuItemChecked( int id, bool state ) {
  ::CheckMenuItem( hMenu, id, MF_BYCOMMAND|(state?MF_CHECKED:MF_UNCHECKED));
}

inline void Menu::setMenuItemEnabled( int id, bool state ) {
  ::EnableMenuItem( hMenu, id, (state?MF_ENABLED:MF_GRAYED) );
}
#endif
