#ifndef LISTBOX_H
#define LISTBOX_H
#include "Window.h"
#include "WinString.h"
#include <commctrl.h>

class ListBox : public Window {
public:
  static const int DEFAULT_STYLE = WS_CHILD|WS_VISIBLE|LBS_NOINTEGRALHEIGHT|
                                   WS_HSCROLL|WS_VSCROLL|LBS_NOTIFY|WS_TABSTOP
                                   ;
public:
  ListBox(HWND parent,DWORD style=DEFAULT_STYLE,DWORD exstyle=WS_EX_CLIENTEDGE);
  ~ListBox();
public:
  int add( LPCTSTR text ) ;
  UINT findStringExact( int start, const TCHAR* s );
  UINT getCaretIndex() const ;
  UINT getItemFromPoint( int x, int y ) ;
  void getItemRect( UINT index, RECT* rc ) ;
  int getItemText( int index, LPTSTR buf ) const ;
  bool getItemText( int index, String& ) const ;
  int  getItemTextLength( int index ) const ;
  UINT getSelectedIndex() const ;
  bool hasIndexSelected() const ;
  void insert( LPCTSTR s, UINT index ) ;
  bool makeDragList() ;
  void remove( UINT index ) ;
  void removeAll() ;
  void replace( UINT index, LPCTSTR s ) ;
  void setHorizontalExtent( int i ) ;
  void setSelectedIndex( UINT index ) ;
  UINT size() const ;
private:
  ListBox( const ListBox& );
  ListBox& operator=( const ListBox& );
};

inline ListBox::ListBox( HWND  parent, DWORD style, DWORD exstyle ) {
  if ( createWindowEx( exstyle, TEXT("LISTBOX"), TEXT(""), style, 0,0,0,0,
                       parent, 0, GetModuleHandle(NULL), 0 ) == NULL ) {
    throw WindowCreationException( _T("Error creating ListBox") );
  }
}

inline ListBox::~ListBox() {
  destroy();
}

// returns zero-based index of added string
inline int ListBox::add( LPCTSTR text ) {
  return sendMessage( LB_ADDSTRING, 0, (LPARAM)text );
}

inline UINT ListBox::findStringExact( int start, const TCHAR* s ) {
  return sendMessage( LB_FINDSTRINGEXACT, start, (LPARAM)s );
}

inline UINT ListBox::getCaretIndex() const {
  return (UINT)SendMessage( getHandle(), LB_GETCARETINDEX, 0, 0 );
}

inline UINT ListBox::getItemFromPoint( int x, int y ) {
  return (UINT) sendMessage( LB_ITEMFROMPOINT, 0, MAKELPARAM(x,y) );
}

inline void ListBox::getItemRect( UINT index, RECT* rc ) {
  SendMessage( getHandle(), LB_GETITEMRECT, index, (LPARAM)rc );
}

inline int ListBox::getItemText( int index, LPTSTR buf ) const  {
  return SendMessage( getHandle(), LB_GETTEXT, index, (LPARAM) buf );
}

bool ListBox::getItemText( int index, String& text ) const{
  int len = getItemTextLength( index );
  TCHAR* buf = (TCHAR*)HeapAlloc(GetProcessHeap(),0,sizeof(TCHAR)*(len+1));
  if ( NULL != buf ) {
    getItemText( index, buf );
    text = buf ;
    HeapFree( GetProcessHeap(), 0, buf );
    return true ;
  }
  return false ;
}

inline int ListBox::getItemTextLength( int index ) const {
  return SendMessage( getHandle(), LB_GETTEXTLEN, index, 0 );
}

inline UINT ListBox::getSelectedIndex() const {
  return (UINT)SendMessage( getHandle(), LB_GETCURSEL, 0, 0 );
}

inline bool ListBox::hasIndexSelected() const {
  return getSelectedIndex() != (UINT)(-1) ;
}

inline void ListBox::insert( LPCTSTR s, UINT index ) {
  SendMessage( getHandle(), LB_INSERTSTRING, index, (LPARAM) s ) ;
}

inline bool ListBox::makeDragList() {
  return MakeDragList(getHandle()) != 0 ;
}

inline void ListBox::remove( UINT index ) {
  SendMessage( getHandle(), LB_DELETESTRING, index, 0 ) ;
}

inline void ListBox::removeAll() {
  SendMessage( getHandle(), LB_RESETCONTENT, 0, 0 );
}

// does a remove, then an insert
inline void ListBox::replace( UINT index, LPCTSTR s ) {
  //SendMessage( hwnd, LB_SETITEMDATA, index, (LPARAM)s );
  remove( index );
  insert( s, index );
}

inline void ListBox::setHorizontalExtent( int i ) {
  SendMessage( getHandle(), LB_SETHORIZONTALEXTENT, i, 0 );
}

inline void ListBox::setSelectedIndex( UINT index ) {
  SendMessage( getHandle(), LB_SETCURSEL, index, 0 );
}

inline UINT ListBox::size() const {
  return ::SendMessage( getHandle(), LB_GETCOUNT, 0, 0 );
}

#endif
