#ifndef AL_WIN_GUI_INPUTDIALOG
#define AL_WIN_GUI_INPUTDIALOG
#include "CustomWindow.h"
#include "TextBox.h"
#include "AcceleratorTable.h"

class InputDialog : public CustomWindow {
public:
  InputDialog( HWND parent, LPCTSTR title, DWORD, DWORD );
  bool show();
  String& getInputString( String& s ) ;
  void setInputString( String& s );
  TextBox& getTextBox() { return textBox; }
private:
  void initAcceleratorTable();
  virtual LRESULT onMessage(UINT msg, WPARAM wParam, LPARAM lParam);
  static LRESULT CALLBACK newEditProc( HWND, UINT, WPARAM, LPARAM );
  TextBox textBox ;
  bool cancelled ;
};

inline void InputDialog::setInputString( String& s ) {
  textBox.setText( s.c_str() );
}

#endif
