#include "InputDialog.h"



static WNDPROC oldEditProc ;

LRESULT CALLBACK InputDialog::newEditProc( HWND hwnd, UINT msg, WPARAM wParam,
                                           LPARAM lParam ) {
  switch ( msg ) {
    case WM_KEYDOWN: {
      if ( VK_RETURN == wParam ) {
        Window textBox( hwnd );
        Window inputDialog( textBox.getParent() );
        Window ownerWindow( inputDialog.getOwner() );

        // Enabling the owner window before hiding the modal window seems to
        // reduce flicker in the owner window.
        ownerWindow.setEnabled( true );
        inputDialog.setVisible( false );

        return 0 ;
      }
      else if ( 'A' == wParam ) {
        if ( GetKeyState( VK_CONTROL ) & 0x1000 ) {
          TextBox::selectAll( hwnd);
          return 0 ;
        }
      }
    }
  }
  return CallWindowProc( oldEditProc, hwnd, msg, wParam, lParam );
}

InputDialog::InputDialog( HWND parent, LPCTSTR title, DWORD s, DWORD x )
  : CustomWindow( title, parent, s, x )
  , textBox( *this,  WS_CHILD|WS_VISIBLE|ES_AUTOHSCROLL, WS_EX_CLIENTEDGE )
  , cancelled( false ) {
  if ( NULL == oldEditProc ) {
    oldEditProc = (WNDPROC) GetWindowLong( textBox, GWL_WNDPROC );
  }
  SetWindowLong( textBox, GWL_WNDPROC, (LONG)newEditProc );
  setClientSize( 200, 22 );
  textBox.setDefaultGuiFont();
}

bool InputDialog::show() {
  getOwner().setEnabled( false );

  setVisible( true );
  textBox.setFocus();

  // let's assume user does not cancel at first
  cancelled = false ;

  MSG msg ;
  while( isVisible() && ::GetMessage(&msg,0,0,0) > 0 ) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  return !cancelled ;
}

String& InputDialog::getInputString( String& s ) {
  return textBox.getText( s );
}

LRESULT InputDialog::onMessage(UINT msg, WPARAM wParam, LPARAM lParam) {
  switch ( msg ) {
    case WM_SIZE: {
      const int clientWidth  = LOWORD( lParam );
      const int clientHeight = HIWORD( lParam );
      RECT rc = { 1, 1, 1, 1 };
      textBox.setMargins( &rc );
      return 0 ;
    }
    case WM_CLOSE: {
      Window ownerWindow = getOwner() ;

      // Enabling the owner window before hiding the modal window seems to
      // reduce flicker in the owner window.
      ownerWindow.setEnabled( true );
      setVisible( false );

      // WM_CLOSE means user does not want to input anything
      cancelled = true ;
      \
      return 0 ;
    }
    default: return CustomWindow::onMessage( msg, wParam, lParam );
  }
}
