#include "CustomWindow.h"



static const TCHAR CUSTOM_WINDOW_CLASS_NAME[]=TEXT("agl.win.gui.CustomWindow");

CustomWindow::CustomWindow( LPCTSTR text,
                            HWND hwndParent,
                            DWORD dwStyle,
                            DWORD dwExStyle ) {
  WNDCLASS wc = {0};
  wc.lpszClassName = CUSTOM_WINDOW_CLASS_NAME;
  wc.hInstance     = GetModuleHandle(0) ;
  wc.hbrBackground = GetSysColorBrush( COLOR_3DFACE );
  wc.lpfnWndProc   = wndproc ;
  wc.hCursor       = LoadCursor(0,IDC_ARROW);
  RegisterClass(&wc);

  if ( createWindowEx( dwExStyle, CUSTOM_WINDOW_CLASS_NAME, text,dwStyle,
                       0,0,0,0,hwndParent,0,GetModuleHandle(0),this) == NULL ) {
    throw WindowCreationException( _T("Error creating CustomWindow") );
  }
}

LRESULT CALLBACK CustomWindow::wndproc( HWND hwnd, UINT msg, WPARAM wParam,
                                        LPARAM lParam ) {
  CustomWindow* self = (CustomWindow*)(LONG_PTR)GetWindowLongPtr(hwnd,
                                                                 GWLP_USERDATA);

  if (msg == WM_NCCREATE) {
    self = (CustomWindow*)(((LPCREATESTRUCT)lParam)->lpCreateParams);
    self->setHandle(hwnd) ;
    SetWindowLongPtr(hwnd, GWLP_USERDATA, (LONG)(LONG_PTR)(self));
  }

  if ( self )
    return self->onMessage( msg, wParam, lParam );

  return DefWindowProc(hwnd, msg, wParam, lParam);
}

LRESULT CustomWindow::onMessage(UINT msg, WPARAM wParam, LPARAM lParam) {
  return DefWindowProc(getHandle(), msg, wParam, lParam);
}
