#include "ConvertUtils.h"
#include <tchar.h>

bool ConvertUtils::stringToInt( const String& s, long& out, long def ) {
  const TCHAR* start = s.c_str() ;
  TCHAR* end ;
  long tmp = _tcstol( start, &end, 0 );

  if ( start == end )   // end pointer left at start; totally invalid number
    return false;

  if ( *end )           // end pointer left in middle; partially invalid number
    return false;

  out = tmp ;

  return true;          // end pointer left at end; a valid number
}

String ConvertUtils::intToString( long i ) {
  TCHAR buf[ 64 ] = _T("");
  _stprintf( buf, _T("%d"), i );
  return buf ;
}
