#include "AcceleratorTable.h"
//------------------------------------------------------------------------------
// AccleratorTable Constructors and Destructors
//------------------------------------------------------------------------------

AcceleratorTable::AcceleratorTable()
  : hAccel( NULL ) {
}

AcceleratorTable::~AcceleratorTable() {
  destroy() ;
}

//------------------------------------------------------------------------------
// AccleratorTable Member Functions
//------------------------------------------------------------------------------

bool AcceleratorTable::create( LPACCEL lpaccl, int cEntries ) {
  destroy() ;
  return (hAccel = CreateAcceleratorTable( lpaccl, cEntries )) != NULL ;
}

void AcceleratorTable::destroy() {
  if ( hAccel ) {
    DestroyAcceleratorTable( hAccel );
    hAccel = NULL ;
  }
}

HACCEL AcceleratorTable::getHandle() const {
  return hAccel ;
}

bool AcceleratorTable::translate( HWND hwnd, LPMSG lpmsg ) {
  return TranslateAccelerator( hwnd, hAccel, lpmsg ) != 0 ;
}
